### 35.3.1. 使用Spock测试Spring Boot应用

如果期望使用Spock测试一个Spring Boot应用，你应该将Spock的spock-spring模块依赖添加到应用的构建中。spock-spring将Spring的测试框架集成到了Spock里。

注意你不能使用上述提到的@SpringApplicationConfiguration注解，因为[Spock找不到@ContextConfiguration元注解](https://code.google.com/p/spock/issues/detail?id=349)。为了绕过该限制，你应该直接使用@ContextConfiguration注解，并使用Spring Boot特定的上下文加载器来配置它。
```java
@ContextConfiguration(loader = SpringApplicationContextLoader.class)
class ExampleSpec extends Specification {
// ...
}
```
**注**：上面描述的注解在Spock中可以使用，比如，你可以使用@WebIntegrationTest注解你的Specification以满足测试需要。
